// MCAttribute:Object
//
//
// REVISION HISTORY:
// Wed Mar  2 08:25:01 EST 1994 (MO)
// Starting point.
// 
// A kind of Object which represents a pair of selectors implemented
// by a data modelling object.

#import <Foundation/Foundation.h>

typedef enum {
    CCS_NOTYPE,
    CCS_INTEGER,
    CCS_STRING,
    CCS_FLOAT,
    CCS_DOUBLE,
	CCS_OBJECT,
    CCS_CHAR
} CCSAttributeType;


// Interface

@interface MCAttribute:NSObject
{
    id		model;
    NSString	*attributeName;

    id		leaf;			// leaf node for relationship list
    id		relationships;		// list of related attributes
}

// FACTORY METHODS

+ (void)initialize;

+ newAttributeNamed:(NSString *)aName;
+ newAttributeNamed:(NSString *)aName forModel:aModel;
+ newAttributeNamed:(NSString *)aName forModel:aModel fromZone:(NSZone *)aZone;

// INSTANCE METHODS

- init;
- initAttributeNamed:(NSString *)aName forModel:aModel;

// ACCESSOR METHODS

- model;
- (void)setModel:aModel;

- (NSString *)leafAttribute;
- (NSString *)firstAttribute;
- (NSString *)attribute;		// Same as leafAttribute
- (NSString *)attributeName;	// Returns full attribute 
- (void)setAttributeName:(NSString *)aName;

// RETURNING THE ATTRIBUTE TYPE

- (CCSAttributeType)attributeType;

// TESTING THE LEVEL OF SUPPORT FOR THE ATTRIBUTE IN THE MODEL

- (BOOL)isReadable;
- (BOOL)isWritable;
- (BOOL)isReadWritable;

// FETCHING THE RELATED OBJECT

- fetchRelatedObject;

// GETTING AND SETTING VALUES FOR THE ATTRIBUTE

- getValue;
- (void)setValue:aValue;

// TYPED STREAM SUPPORT

- (id)initWithCoder:(NSCoder *)aDecoder;
- (void)encodeWithCoder:(NSCoder *)aCoder;
- copyWithZone:(NSZone *)zone;

@end
